dofile("./Scripts/Database/wsTypes.lua");


Names = {
			   --[[       Khersones,             -- "Херсонес",
			                    Saki,                  -- "Саки",
			                    Simpheropol,           -- "Симферополь",
			                    Razdolnoe,             -- "Раздольное",
			                    Dzhankoy,              -- "Джанкой",
			                    Kirovskoe,             -- "Кировское",
			                    Kerch,                 -- "Керчь-Багерово",
			                    Belbek,                -- "Бельбек",
			                    Krasnogvardeyskoye,    -- "Красногвардейское",
			                    Octyabrskoe,           -- "Октябрьское",
			                    Gvardeyskoe,           -- "Гвардейское",  --]]
                    Anapa,                 -- "Анапа-Витязево",
                    Krasnodar,             -- "Краснодар",
                    Novorossiysk,          -- "Новороссийск",
                    Krymsk,                -- "Крымск",
                    Maykop,                -- "Майкоп-Ханская",
                    Gelendzhik,            -- "Геленджик",
                    Sochi,                 -- "Сочи-Адлер",
                    Krasnodar_P,           -- "Краснодар-Пашковский",
                    Sukhumi,               -- "Сухуми-Бабушара",
                    Gudauta,               -- "Гудаута",
                    Batumi,                -- "Батуми",
                    Tskhakaya,             -- "Цхакая",
                    Kobuleti,              -- "Кобулети",
                    Kutaisi,               -- "Кутаиси",
                    MinVody,               -- "Минеральные Воды",
                    Nalchick,              -- "Нальчик",
}



AirdromeName_russian={
                    [Khersones]             = "Херсонес",
                    [Saki]                  = "Саки",
                    [Simpheropol]           = "Симферополь",
                    [Razdolnoe]             = "Раздольное",
                    [Dzhankoy]              = "Джанкой",
                    [Kirovskoe]             = "Кировское",
                    [Kerch]                 = "Керчь-Багерово",
                    [Belbek]                = "Бельбек",
                    [Krasnogvardeyskoye]    = "Красногвардейское",
                    [Octyabrskoe]           = "Октябрьское",
                    [Gvardeyskoe]           = "Гвардейское",
                    [Anapa]                 = "Анапа-Витязево",
                    [Krasnodar]             = "Краснодар-Центральный",
                    [Novorossiysk]          = "Новороссийск",
                    [Krymsk]                = "Крымск",
                    [Maykop]                = "Майкоп-Ханская",
                    [Gelendzhik]            = "Геленджик",
                    [Sochi]                 = "Сочи-Адлер",
                    [Krasnodar_P]           = "Краснодар-Пашковский",
                    [Sukhumi]               = "Сухуми-Бабушара",
                    [Gudauta]               = "Гудаута",
                    [Batumi]                = "Батуми",
                    [Tskhakaya]             = "Цхакая",
                    [Kobuleti]              = "Кобулети",
                    [Kutaisi]               = "Кутаиси",
                    [MinVody]               = "Минеральные Воды",
                    [Nalchick]              = "Нальчик",
}

AirdromeName_english = {
                    [Khersones]             = "Khersones",			
                    [Saki]                  = "Saki",				
                    [Simpheropol]           = "Simferopol",			
                    [Razdolnoe]             = "Razdolnoye",			
                    [Dzhankoy]              = "Dzhankoy",			
                    [Kirovskoe]             = "Kirovskoye",			
                    [Kerch]                 = "Kerch-Bagerovo",		
                    [Belbek]                = "Belbek",				
                    [Krasnogvardeyskoye]    = "Krasnogvardeyskoye",	
                    [Octyabrskoe]           = "Octyabrskoye",		
                    [Gvardeyskoe]           = "Gvardeyskoye",		
                    [Anapa]                 = "Anapa",				
                    [Krasnodar]             = "Krasnodar-Center",	
                    [Novorossiysk]          = "Novorossiysk",
                    [Krymsk]                = "Krymsk",
                    [Maykop]                = "Maykop",
                    [Gelendzhik]            = "Gelendzhik",			
                    [Sochi]                 = "Sochi-Adler",		
                    [Krasnodar_P]           = "Krasnodar-Pashkovsky",
                    [Sukhumi]               = "Sukhumi",			
                    [Gudauta]               = "Gudauta",			
                    [Batumi]                = "Batumi",				
                    [Tskhakaya]             = "Tskhakaya",			
                    [Kobuleti]              = "Kobuleti",           
                    [Kutaisi]               = "Kutaisi",   
                    [MinVody]               = "Mineralnye Vody",
                    [Nalchick]              = "Nalchick",
}

AirdromeRoadNetDeclaration = {"KHERSONES",
                              "SAKI",
                              "SIMFEROPOL",
                              "RAZDOLNOE",
                              "DJANKOJ",
                              "KIROVSKOYE",
                              "KERCH",
                              "BELBECK",
                              "KRASNOGVARD",
                              "OKTYABRSKOE",
                              "GVARDEJSKOE",
                              "ANAPA",
                              "KRASNODAR",
                              "NOVOROSSIYSK",
                              "KRYMSK",
                              "MAYKOP",
                              "GELENDZHIK",
                              "SOCHI_ADLER",
                              "KRASNODAR_P",
                              "SUKHUMI",
                              "GUDAUTA",
                              "BATUMI",
                              "TSKHAKAYA",
                              "KOBULETI",
                              "KUTAISI",
                              "MINVODY",
							  "NALCHIK"}    
                            
                            
AirdromeShapeDeclaration = {{ intpoint = {3, 9 }      ,shape = "Bazar\\Terrain\\Vpp\\A0R0104S11" },
                            { intpoint = {5, 10 }     ,shape = "Bazar\\Terrain\\Vpp\\A0R0205S10"},
                            { intpoint = {9, 10 }     ,shape = "Bazar\\Terrain\\Vpp\\A0R0405S10"},
                            { intpoint = {8, 13 }     ,shape = "Bazar\\Terrain\\Vpp\\A0R0406S01"},
                            { intpoint = {9, 13 }     ,shape = "Bazar\\Terrain\\Vpp\\A0R0406S11"},
                            { intpoint = {10, 23 }    ,shape = "Bazar\\Terrain\\Vpp\\A0R0511S01"},
                            { intpoint = {12, 14 }    ,shape = "Bazar\\Terrain\\Vpp\\A0R0607S00"},
                            { intpoint = {13, 31 }    ,shape = "Bazar\\Terrain\\Vpp\\A0R0615S11"},
                            { intpoint = {15, 16 }    ,shape = "Bazar\\Terrain\\Vpp\\A0R0708S10"},
                            { intpoint = {16, 10 }    ,shape = "Bazar\\Terrain\\Vpp\\A0R0805S00"},
                            { intpoint = {16, 17 }    ,shape = "Bazar\\Terrain\\Vpp\\A0R0808S01"},
                            { intpoint = { 9, 40 }    ,shape = "Bazar\\Terrain\\Vpp\\Anapa"},
                            { intpoint = {-200, -200 },shape = "Bazar\\Terrain\\Vpp\\Krasnodar"},
                            { intpoint = { 5, 43 }    ,shape = "Bazar\\Terrain\\Vpp\\Novorossiysk"},
                            { intpoint = { 9, 45 }    ,shape = "Bazar\\Terrain\\Vpp\\Krymsk"},
                            { intpoint = { 7, 61 }    ,shape = "Bazar\\Terrain\\Vpp\\Maykop"},
                            { intpoint = { 4, 45 }    ,shape = "Bazar\\Terrain\\Vpp\\Gelendzhik"},
                            { intpoint = { 9, 62 }    ,shape = "Bazar\\Terrain\\Vpp\\Sochi-Adler"},
                            { intpoint = {10, 54 }    ,shape = "Bazar\\Terrain\\Vpp\\Krasnodar-P"},
                            { intpoint = {-201, -201 },shape = "Bazar\\Terrain\\Vpp\\Sukhumi"},
                            { intpoint = {-202, -202 },shape = "Bazar\\Terrain\\Vpp\\Gudauta"},
                            { intpoint = {-202, -202 },shape = "Bazar\\Terrain\\Vpp\\BATUMI"},
                            { intpoint = {-202, -202 },shape = "Bazar\\Terrain\\Vpp\\TSKHAKAYA"},
                            { intpoint = {-202, -202 },shape = "Bazar\\Terrain\\Vpp\\KOBULETI"},
                            { intpoint = {-202, -202 },shape = "Bazar\\Terrain\\Vpp\\KUTAISI"},
                            { intpoint = {-202, -202 },shape = "Bazar\\Terrain\\Vpp\\MynVody"},
							{ intpoint = {-202, -202 },shape = "Bazar\\Terrain\\Vpp\\Nalchik"},
                            }

                            
        
hel_terminal = {13,
                63,
                37,
                61,
                49,
                61,
                65,
                59,
                44,
                61,
                53,	
                43,
                50,
                23,
                50,
                63,
                34,
                28,
                37,
                42,
                30,
                16,
                16,
                16,
                16,
                16,
				16}

function GetHelTerm(id)
    return hel_terminal[id]
end 
                
military = {}

for i = 1,LAST_AIRDROME_TYPE do
    military[i] = true
end

military[Simpheropol]   = false
military[Dzhankoy]      = false
military[Anapa]         = false
military[Krasnodar_P]   = false
military[Sukhumi]       = false
military[Batumi]        = false
military[Kutaisi]       = false
military[Gelendzhik]    = false
military[Sochi]         = false
military[Kobuleti]      = false
military[Belbek]        = false
military[MinVody]       = false
military[Nalchick]      = false



function GetIsMilitary(id)
    return military[id]
end     

     
kdp =
{
	{-61729.172,	110.0, -68106.453},	    -- 0 Херсонес
	{-5163.503,		150.0, -52801.59},	    -- 1 Саки
	{-9154.209,		160.0, -22654.078},	    -- 2 Симферополь
	{ 67870.609,	150.0, -59135.027},	    -- 3 Раздольное
	{ 63676.871,	150.0,	10661.475},	    -- 4 Джанкой
	{ 5854.971,		190.0,	72211.555},	    -- 5 Кировское
	{ 33940.621,	210.0,	155181.078},	-- 6 Багерово
	{-49501.426,	190.0, -54885.09},	    -- 7 Бельбек
	{ 50080.523,	150.0,	925.858},		-- 8 Красногвардейское
	{ 21939.803,	150.0, -14006.732},	    -- 9 Октябрьское
	{-2157.586,		150.0, -23384.529},	    -- 10 Гвардейское
	{-4737.023,		145.0,	242694.906},	-- 11 Анапа
	{11046.899,		130.0,	367780.875},	-- 12 Краснодар-Центр
	{-40432.367,	140.0,	279253.563},	-- 13 Новороссийск
	{-6714.982,		120.0,	294749.531},	-- 14 Крымск
	{-26871.365,	280.0,	458253.906},	-- 15 Майкоп
	{-50287.102,	125.0,	298195.469},	-- 16 Геленджик
	{-164274.344,	130.0,	461912.719},	-- 17 Сочи(Адлер)
	{8014.047,		134.0,	386493.688},	-- 18 Краснодар-Пашковский
	{-220014.719,	115.0,	564311.188},	-- 19 Сухуми
	{-196858.828,	121.0,	515831.781},	-- 20 Гудаута
	{-355509.094,	110.0,	617577.938},	-- 21 Батуми
	{-281271.656,	112.0,	647057.438},	-- 22 Цхакая
	{-317802.938,	118.0,	635465.938},	-- 23 Кобулети
	{-284569.750,	145.0,	683788.250},	-- 24 Котуаси
};
-- Начальные направления свободных камер - на начало взлетной полосы
brn =
{
	145.0,		-- 0 Херсонес
	128.8,		-- 1 Саки
	151.9,		-- 2 Симферополь
	186.9,		-- 3 Раздольное
	151.0,		-- 4 Джанкой
	82.8,		-- 5 Кировское
	91.1,		-- 6 Багерово
	96.6,		-- 7 Бельбек
	115.9,		-- 8 Красногвардейское
	107.6,		-- 9 Октябрьское
	152.7,		-- 10 Гвардейское
	164.5,		-- 11 Анапа
	297.0,		-- 12 Краснодар-Центр
	152.5,		-- 13 Новороссийск
	342.2,		-- 14 Крымск
	334.7,		-- 15 Майкоп
	156.0,		-- 16 Геленджик
	132.5,		-- 17 Сочи(Адлер)
	116.0,		-- 18 Краснодар-Пашковский
	228.0,		-- 19 Сухуми
	233.0,		-- 20 Гудаута
	216.5,		-- 21 Батуми
	118.5,		-- 22 Цхакая
	121.0,		-- 23 Кобулети
	120.5,		-- 24 Кутаиси
};


-- Индексы аэродромов должны соответствовать индексам wsType.level4 - 1.
-- Начальные позиции свободных камер - примерно на 100 метров выше поверхности
function GetAirdromesCameraPoint(id)
    local pnt = kdp[id]
    if pnt ~= nil then
       return pnt[1],pnt[2],pnt[3]
    else 
       return 0,0,0
    end
end

-- Начальные направления свободных камер - на начало взлетной полосы

function GetAirdromesCameraBearing(id)
 local pnt = brn[id]
    if pnt ~= nil then
       return pnt
    else 
       return 0
    end 
end



base_displacement_landing =
{
    {x = 50.0,  z =-125.0},--1,   Херсонес
    {x =750.0,  z = 610.0},--2,   Саки
    {x =  0.0,  z = -50.0},--3,   Симферополь гражданский
    {x =  0.0,  z =   0.0},--4,   Раздольное 
    {x =  0.0,  z =   0.0},--5,   Джанкой
    {x =  0.0,  z = 110.0},--6,   Кировское
    {x =  0.0,  z = -50.0},--7,   Багерово (Керчь)
    {x =  0.0,  z = -50.0},--8,   Бельбек
    {x =614.0,  z = -50.0},--9,   Красногвардейское
    {x =190.0,  z = -50.0},--10,  Октябрьское
    {x =680.0,  z = -50.0},--11,  Симферополь военный
    {x =  0.0,  z = 250.0},--12,  Анапа
    {x =  0.0,  z = 300.0},--13,  Краснодар гражданский
    {x =1400.0, z = -35.0},--14,  Новороссийск
    {x =  0.0,  z = 300.0},--15,  Крымск
    {x =  0.0,  z = 300.0},--16,  Майкоп
    {x = 150.0, z = 200.0},--17,  Геленджик
    {x = 960.0, z =-200.0},--18,  Сочи (Адлер)
    {x =  0.0,  z = 200.0},--19,  Краснодар 
    {x =  0.0,  z =-220.0},--20,  Сухуми
    {x =  0.0,  z = 300.0},--21,  Гудаута
    {x =  0.0,  z = 200.0},--22, Батуми
    {x =  0.0,  z = 200.0},--23, Цхакая
    {x =  0.0,  z = 200.0},--24, Кобулетти
    {x =  0.0,  z = 200.0},--25, Кутаиси
    {x =  0.0,  z = 200.0},--26, Минеральные Воды
	{x =  0.0,  z = 200.0},--27, Нальчик
}

base_displacement_takeoff =
{
    {x = 270.0,  z = 110.0},--1,   Херсонес
    {x =   0.0,  z = 170.0},--2,   Саки
    {x = 400.0,  z = 110.0},--3,   Симферополь гражданский
    {x = 100.0,  z = -50.0},--4,   Раздольное 
    {x =   0.0,  z = -50.0},--5,   Джанкой
    {x = 100.0,  z = -50.0},--6,   Кировское
    {x = 280.0,  z = 110.0},--7,   Багерово (Керчь)
    {x =   0.0,  z = 320.0},--8,   Бельбек
    {x =   0.0,  z = 200.0},--9,   Красногвардейское
    {x = 700.0,  z = 110.0},--10,  Октябрьское
    {x = 100.0,  z = 110.0},--11,  Симферополь военный
    {x =   0.0,  z = 400.0},--12,  Анапа
    {x =   0.0,  z = 500.0},--13,  Краснодар гражданский
    {x =1400.0,  z = -35.0},--14,  Новороссийск
    {x =   0.0,  z = 400.0},--15,  Крымск
    {x =   0.0,  z = 400.0},--16,  Майкоп
    {x = 550.0,  z =-210.0},--17,  Геленджик
    {x = 960.0,  z =-270.0},--18,  Сочи (Адлер)
    {x =   0.0,  z = 300.0},--19,  Краснодар 
    {x =   0.0,  z =-220.0},--20,  Сухуми
    {x =   0.0,  z = 400.0},--21,  Гудаута
    {x =   0.0,  z = 200.0},--22, Батуми
    {x =   0.0,  z = 200.0},--23, Цхакая
    {x =   0.0,  z = 200.0},--24, Кобулетти
    {x =   0.0,  z = 200.0},--25, Кутаиси
    {x =   0.0,  z = 200.0},--26, Минеральные Воды
	{x =   0.0,  z = 200.0},--27, Нальчик
}

towerObjectModels = {"KDP_BIG", "KDP", "Zil_SKP-11", "KP_UG", "HMMWV_M1025"}

Airdromes = {
	[Khersones] = {
		code = "UKFH", --realy unknown
		callsign = "CALLSIGN_1",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Saki] = {
		code = "UKFI",
		callsign = "CALLSIGN_2",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Simpheropol] = {
		code = "UKFF",
		callsign = "CALLSIGN_3",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Razdolnoe] = {
		code = "UKFZ", --realy unknown
		callsign = "CALLSIGN_4",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Dzhankoy] = {
		code = "UKFY",
		callsign = "CALLSIGN_1",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Kirovskoe] = {
		code = "UKFV", --realy unknown
		callsign = "CALLSIGN_1",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Kerch] = {
		code = "UKFR",
		callsign = "CALLSIGN_1",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Belbek] = {
		code = "UKFL",
		callsign = "CALLSIGN_1",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Krasnogvardeyskoye] = {
		code = "UKFK", --realy unknown
		callsign = "CALLSIGN_1",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Octyabrskoe] = {
		code = "UKFO", --realy unknown
		callsign = "CALLSIGN_1",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Gvardeyskoe] = {
		code = "UKFG", --realy unknown
		callsign = "CALLSIGN_1",
		frequency = 127500000.0,
		control_tower = towerObjectModels
	},
	[Anapa] = {
		code = "URKA",
		callsign = "Anapa",
		frequency = 119800000,
		control_tower = towerObjectModels
	},
	[Krasnodar] = {
		code = "UNOO",
		callsign = "Volokno",
		frequency = 119000000,
		control_tower = towerObjectModels
	},
	[Novorossiysk] = {
		code = "URKN", --realy unknown
		callsign = "Myskhako",
		frequency = 123000000,
		control_tower = towerObjectModels
	},
	[Krymsk] = {
		code = "URKW",
		callsign = "Taymyr",
		frequency = 124000000,
		control_tower = towerObjectModels
	},
	[Maykop] = {
		code = "URKM",
		callsign = "Sokratus",
		frequency = 125000000,
		control_tower = towerObjectModels
	},
	[Gelendzhik] = {
		code = "URKG", --realy unknown
		callsign = "Maslenka",
		frequency = 126000000,
		control_tower = towerObjectModels
	},
	[Sochi] = {
		code = "URSS",
		callsign = "Sochi",
		frequency = 121200000,
		control_tower = towerObjectModels
	},
	[Krasnodar_P] = {
		code = "URKK",
		callsign = "Krasnodar",
		frequency = 120600000,
		control_tower = towerObjectModels
	},
	[Sukhumi] = {
		code = "UGSS",
		callsign = "Uklad",
		frequency = 129000000,
		control_tower = towerObjectModels
	},
	[Gudauta] = {
		code = "UG23",
		callsign = "Lachuga",
		frequency = 13000000,
		control_tower = towerObjectModels
	},
	[Batumi] = {
		code = "UGSB",
		callsign = "Druzhinnick",
		frequency = 118600000,
		control_tower = towerObjectModels
	},
	[Tskhakaya] = {
		code = "UGST", --realy unknown
		callsign = "Tsokot",
		frequency = 132000000,
		control_tower = towerObjectModels
	},
	[Kobuleti] = {
		code = "UG5X", --realy unknown
		callsign = "Kobuleti",
		frequency = 133000000,
		control_tower = towerObjectModels
	},
	[Kutaisi] = {
		code = "UGKO",
		callsign = "Kutaisi",
		frequency = 125500000,
		control_tower = towerObjectModels
	},
	[MinVody] = {
		code = "URMM",
		callsign = "Min.Vody",
		frequency = 128000000,
		control_tower = towerObjectModels
	},
	[Nalchick] = {
		code = "URMN",
		callsign = "Nalchick",
		frequency = 118300000,
		control_tower = towerObjectModels
	},
}

SingleDirectionalAirfields= {
    [Sochi]        = 0,
    [Nalchick]     = 0,
    [Novorossiysk] = 1,
    [Batumi]       = 1,
    [Gelendzhik]   = 1,
}
----------------------------------------------------------------------------------------------------------------------
function GetHelicopterLandingPoint(id,point_number)       
        local  p = base_displacement_landing[id]
        local  x = p.x + 50.0 * point_number
        local  z = p.z
        return x,z
end
----------------------------------------------------------------------------------------------------------------------
function GetHelicopterTakeoffPoint(id,point_number)       
        local  p = base_displacement_takeoff[id]
        local  x = p.x + 42.0 * (GetHelTerm(id) - point_number)
        local  z = p.z
        return x,z
end
----------------------------------------------------------------------------------------------------------------------
